' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient

Public Class ContentDB

  Private Sub New()
    ' Ukryj konstruktor poniewaz ta klasa udostpnia tylko skadniki wspuytkowane
  End Sub

  ''' <summary>
  ''' Zapisuje jednostk treci w bazie danych.
  ''' </summary>
  ''' <param name="contentItem">Obiekt <see cref="Content">Content</see>, ktry ma by zapisany.</param>
  ''' <remarks>Ta metoda moe by uyta do zapisania nowych i istniejcych jednostek treci. Kiedy <see cref="Content.Id">Id</see> jednostki treci wynosi -1 (co jest wartoci domyln) tworzona jest nowa jednostka. W przeciwnym przypadku aktualizowa jest istniejca jednostka treci.</remarks>
  Public Shared Sub Save(ByVal contentItem As Content)

    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocContentInsertUpdateSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If contentItem.Id > 0 Then
        myCommand.Parameters.AddWithValue("@id", contentItem.Id)
      End If
      myCommand.Parameters.AddWithValue("@title", contentItem.Title)
      myCommand.Parameters.AddWithValue("@introText", contentItem.IntroText)
      myCommand.Parameters.AddWithValue("@bodyText", contentItem.BodyText)
      myCommand.Parameters.AddWithValue("@contentTypeId", contentItem.ContentTypeId)
      myCommand.Parameters.AddWithValue("@categoryId", contentItem.CategoryId)
      myCommand.Parameters.AddWithValue("@visible", contentItem.Visible)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

  ''' <summary>
  ''' Pobiera z bazy danych jednostk treci w oparciu o jej identyfikator.
  ''' </summary>
  ''' <param name="id">identyfikator jednostki treci bazie danych.</param>
  ''' <returns>Egzemplarz klasy Content, jeli jednostka treci zostaa znaleziona, lub <see langword="null"/>, jeli nie.</returns>
  Public Shared Function GetItem(ByVal id As Integer) As Content
    Dim theContentItem As Content = Nothing
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
      Dim myCommand As SqlCommand = New SqlCommand _
          ("sprocContentSelectSingleItem", myConnection)

      myCommand.CommandType = CommandType.StoredProcedure
      myCommand.Parameters.AddWithValue("@id", id)
      myConnection.Open()

      Using myReader As SqlDataReader = _
          myCommand.ExecuteReader(CommandBehavior.CloseConnection)
        If myReader.Read Then
          theContentItem = New Content(myReader.GetInt32(myReader.GetOrdinal("Id")))
          theContentItem.Title = myReader.GetString(myReader.GetOrdinal("Title"))
          theContentItem.IntroText = myReader.GetString(myReader.GetOrdinal("IntroText"))
          theContentItem.BodyText = myReader.GetString(myReader.GetOrdinal("BodyText"))
          theContentItem.ContentTypeId = myReader.GetInt32(myReader.GetOrdinal("ContentTypeId"))
          theContentItem.CategoryId = myReader.GetInt32(myReader.GetOrdinal("CategoryId"))
          theContentItem.Visible = _
              myReader.GetBoolean(myReader.GetOrdinal("Visible"))
          If Not myReader.IsDBNull(myReader.GetOrdinal("PageViews")) Then
            theContentItem.PageView = myReader.GetInt32(myReader.GetOrdinal("PageViews"))
          End If
        End If
        myReader.Close()
      End Using
    End Using
    Return theContentItem
  End Function
End Class
